/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.hmcconfg;

import com.ibm.hwmca.base.hmcconfg.HmcConfigErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;

public class HmcConfigBean
extends PanelBean
implements HmcConfigErrorIds {
    private static final String TRACE_MASKT = "HCONCGBT";
    private static final String TRACE_MASKF = "HCONCGBF";
    private static final String TRACE_MASKD = "HCONCGBD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(97, "HmcConfgBean");
    public static final String COMMAND_DATA = "command";
    public static final String BEAN_DATA = "bean";
    public static final String CANCEL_BUTTON = "CANCEL";
    public static final String OK_BUTTON = "OkButton";
    private String m_sSystemMachineTypeEdit;
    private String m_sSystemModelEdit;
    private String m_sSystemSerialEdit;
    private String m_sHmcMachineTypeOutput;
    private String m_sHmcModelOutput;
    private String m_sHmcSerialOutput;
    private transient boolean dataHasChanged;

    public String getSystemMachineTypeEdit() {
        Trace.trace(TRACE_MASKT, "<> HmcConfigBean.getSystemMachineTypeEdit()");
        return this.m_sSystemMachineTypeEdit;
    }

    public void setSystemMachineTypeEdit(String s) {
        Trace.trace(TRACE_MASKT, "-> HmcConfigBean.setSystemMachineTypeEdit()");
        if (!s.equals(this.m_sSystemMachineTypeEdit)) {
            this.dataHasChanged = true;
            this.m_sSystemMachineTypeEdit = s;
        }
        Trace.trace(TRACE_MASKT, "<- HmcConfigBean.setSystemMachineTypeEdit()");
    }

    public String getSystemModelEdit() {
        Trace.trace(TRACE_MASKT, "<> HmcConfigBean.getSystemModelEdit()");
        return this.m_sSystemModelEdit;
    }

    public void setSystemModelEdit(String s) {
        Trace.trace(TRACE_MASKT, "-> HmcConfigBean.setSystemModelEdit()");
        if (!s.equals(this.m_sSystemModelEdit)) {
            this.dataHasChanged = true;
            this.m_sSystemModelEdit = s;
        }
        Trace.trace(TRACE_MASKT, "<- HmcConfigBean.setSystemModelEdit()");
    }

    public String getSystemSerialEdit() {
        Trace.trace(TRACE_MASKT, "<> HmcConfigBean.getSystemSerialEdit()");
        return this.m_sSystemSerialEdit;
    }

    public void setSystemSerialEdit(String s) {
        Trace.trace(TRACE_MASKT, "-> HmcConfigBean.setSystemSerialEdit()");
        if (!s.equals(this.m_sSystemSerialEdit)) {
            this.dataHasChanged = true;
            this.m_sSystemSerialEdit = s;
        }
        Trace.trace(TRACE_MASKT, "<- HmcConfigBean.setSystemSerialEdit()");
    }

    public String getHmcMachineTypeOutput() {
        Trace.trace(TRACE_MASKT, "<> HmcConfigBean.getHmcMachineTypeOutput()");
        return this.m_sHmcMachineTypeOutput;
    }

    public void setHmcMachineTypeOutput(String s) {
        Trace.trace(TRACE_MASKT, "<> HmcConfigBean.setHmcMachineTypeOutput()");
        this.m_sHmcMachineTypeOutput = s;
    }

    public String getHmcModelOutput() {
        Trace.trace(TRACE_MASKT, "<> HmcConfigBean.getHmcModelOutput()");
        return this.m_sHmcModelOutput;
    }

    public void setHmcModelOutput(String s) {
        Trace.trace(TRACE_MASKT, "<> HmcConfigBean.setHmcModelOutput()");
        this.m_sHmcModelOutput = s;
    }

    public String getHmcSerialOutput() {
        Trace.trace(TRACE_MASKT, "<> HmcConfigBean.getHmcSerialOutput()");
        return this.m_sHmcSerialOutput;
    }

    public void setHmcSerialOutput(String s) {
        Trace.trace(TRACE_MASKT, "<> HmcConfigBean.setHmcSerialOutput()");
        this.m_sHmcSerialOutput = s;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() {
    }

    public void save() {
    }

    public void load() {
    }

    private boolean hasChanged() {
        Trace.trace(TRACE_MASKT, "<> HmcConfigBean.hasChanged()");
        return this.dataHasChanged;
    }

    public void panelAction(TaskActionEvent evt) {
        IllegalUserDataException uiExc = null;
        String command = null;
        try {
            UserTaskManager utm = (UserTaskManager)evt.getSource();
            command = evt.getActionCommand();
            Trace.trace(TRACE_MASKT, "-> HmcConfigBean for command: [" + command + "].");
            utm.storeAllElements();
            HmcConfigBean bean = (HmcConfigBean)utm.getDataObjects()[0];
            if (command.equals(CANCEL_BUTTON)) {
                Trace.trace(TRACE_MASKF, "HmcConfigBean checking to see if data changed");
                boolean bEndDialog = true;
                if (bean.hasChanged()) {
                    Trace.trace(TRACE_MASKF, "we think data has changed");
                    if (!CommonMsgApp.showDataChangedConfirmation(utm)) {
                        uiExc = new IllegalUserDataException();
                        bEndDialog = false;
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "we do not think data has changed");
                }
                if (bEndDialog) {
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData(COMMAND_DATA, command);
                    this.postTaskletRequest(request);
                }
            } else if (command.equals(OK_BUTTON)) {
                Trace.trace(TRACE_MASKF, "posting ok request");
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData(COMMAND_DATA, command);
                request.setData(BEAN_DATA, bean);
                this.postTaskletRequest(request);
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception in action handler = " + exc);
            new FrameworkLog(logInfo, 515, exc).log();
            this.dispose();
        }
        if (uiExc != null) {
            Trace.trace(TRACE_MASKF, "Throwing new IllegalUserDataException");
            throw uiExc;
        }
        Trace.trace(TRACE_MASKT, "<- HmcConfigBean for command: [" + command + "].");
    }
}

